#ifndef _ROUTINES_CPP
#define _ROUTINES_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <WinSock.H>
#include <Windows.H>
#include <WindowsX.H>
#include <ShlOBJ.H>
#include <CommCtrl.H>
#include <StdIO.H>
#include <IO.H>
#include <IPHlpAPI.h>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "NSWFL.H"
#include "Debug.H"
#include "Init.H"
#include "Entry.H"
#include "Routines.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/ScanDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD dwPOPGrid_Thread_ID;
HANDLE hPOPGrid_Thread;
HIMAGELIST ghImageList;

int giContainerCount = 0;

HWND hLanViewListBox = NULL;
HWND hStatusBar = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool GetRemoteMAC(char *inIPAddress, char *outMACAddr, int iMaxSz)
{
    HRESULT hr;
    IPAddr  ipAddr;
    ULONG   pulMac[2];
    ULONG   ulLen = 6;

    if((ipAddr = inet_addr(inIPAddress)) == INADDR_NONE)
        return false;

    memset(pulMac, 0, sizeof(pulMac));

    if( (hr = SendARP (ipAddr, 0, pulMac, &ulLen)) != NO_ERROR)
        return false;

    ULONG LoopPos = 0;
    ULONG BufPos = 0;
    PBYTE pbHexMac = (PBYTE) pulMac;

    while(LoopPos < (ulLen - 1))
    {
        BufPos += sprintf_s(outMACAddr + BufPos, iMaxSz - BufPos, "%02X:", pbHexMac[LoopPos]);
        LoopPos++;
    }

    sprintf_s(outMACAddr + BufPos, iMaxSz - BufPos, "%02X", pbHexMac[LoopPos]);

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////

bool ResolveIP(char *IPAddress, char *outHostName, int iMaxSz)
{
	unsigned long HostAddress = inet_addr(IPAddress);
    if(HostAddress == INADDR_NONE)
        return false;

	struct hostent *HostData = gethostbyaddr((char*)&HostAddress, sizeof(unsigned long), AF_INET);
	if(HostData == NULL)
		return false;

    strcpy_s(outHostName, iMaxSz, HostData->h_name);

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ResolveHost(char *xHostName, int AddressNum, char *outIPAddress, int iMaxSz)
{
    char *IPAddress = NULL;
    struct hostent *Host;
    struct in_addr Address;

    if((Host = gethostbyname(xHostName)) == NULL)
        return false;
    
    if(Host->h_addr_list[AddressNum] == NULL)
        return false;

    memcpy(&Address.s_addr, Host->h_addr_list[AddressNum], Host->h_length);

    if((IPAddress = inet_ntoa(Address)) == NULL)
        return false;

    strcpy_s(outIPAddress, iMaxSz, IPAddress);

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool GetNodeInformation(char *NodeName)
{
    int AddrPos = 0;
    int MACAddrCount = 0;

    char MacAddr[255];
    char IPAddress[255];
    char HostName[255];

    bool ReturnValue = true;
    bool ResolvedHost = true;

    char IPAddressList[2048];
    char MACAddressList[2048];

	LV_ITEM MyLV_Item;
	memset(&MyLV_Item, 0, sizeof(MyLV_Item));

	while(ResolveHost(NodeName, AddrPos, IPAddress, sizeof(IPAddress)))
    {
        if(AddrPos == 0)
        {
            strcpy_s(IPAddressList, sizeof(IPAddress), IPAddress);
        }
        else{
            strcat_s(IPAddressList, sizeof(IPAddress), ", ");
            strcat_s(IPAddressList, sizeof(IPAddress), IPAddress);
        }

        MyLV_Item.pszText  = IPAddressList;
        MyLV_Item.mask     = LVIF_TEXT;
        MyLV_Item.iSubItem = 3;
        ListView_SetItem(hLanViewListBox, &MyLV_Item);

        if(ResolveIP(IPAddress, HostName, sizeof(HostName)))
        {
            MyLV_Item.pszText  = HostName;
            MyLV_Item.mask     = LVIF_TEXT;
            MyLV_Item.iSubItem = 2;
            ListView_SetItem(hLanViewListBox, &MyLV_Item);
        }
        else ReturnValue = false;

        if(GetRemoteMAC(IPAddress, MacAddr, sizeof(MacAddr)))
        {
            if(MACAddrCount == 0)
            {
                strcpy_s(MACAddressList, sizeof(MACAddressList), MacAddr);
            }
            else{
                strcat_s(MACAddressList, sizeof(MACAddressList), ", ");
                strcat_s(MACAddressList, sizeof(MACAddressList), MacAddr);
            }

            MyLV_Item.pszText  = MACAddressList;
            MyLV_Item.mask     = LVIF_TEXT;
            MyLV_Item.iSubItem = 4;
            ListView_SetItem(hLanViewListBox, &MyLV_Item);

            MACAddrCount++;
        }
        else ReturnValue = false;

        ResolvedHost = true;
        AddrPos++;
    }

    if(!ResolvedHost)
	{
        return false;
	}

    return ReturnValue;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL GetNetworkResources(void)
{
    DWORD dwStatus = NO_ERROR;
    HANDLE hEnum = 0;
    DWORD dwBufSz = 5 * 1024;
    DWORD dwEntries = 0xFFFFFFFF;
    char sTemp[1024];

	LV_ITEM MyLV_Item;
	memset(&MyLV_Item, 0, sizeof(MyLV_Item));

    if(WNetOpenEnum(RESOURCE_CONTEXT, RESOURCETYPE_ANY, 0, NULL, &hEnum) != NO_ERROR)
    {
        MessageBox(hMainDialog, "Error in GetNetworkResources: WNetOpenEnum error.", gsTitleCaption, 0);
        return FALSE;
    }

	do
	{
	    NETRESOURCE *LPNR = (NETRESOURCE *) calloc(dwBufSz, 1);

		dwStatus = WNetEnumResource(hEnum, &dwEntries, LPNR, &dwBufSz);

		if(dwStatus != ERROR_MORE_DATA && dwStatus != NO_ERROR)
		{
			break;
		}

        DWORD dwItem = 0;

        while(dwItem < dwEntries)
        {
            if(LPNR[dwItem].lpRemoteName)
            {
                if( LPNR[dwItem].dwDisplayType == RESOURCEUSAGE_CONTAINER)
                {
                    giContainerCount++;

                    Set_Text(hStatusText, LPNR[dwItem].lpRemoteName);

                    MyLV_Item.mask     = LVIF_IMAGE;
                    MyLV_Item.iSubItem = 0;
                    MyLV_Item.iImage   = 0;
                    ListView_InsertItem(hLanViewListBox, &MyLV_Item);

                    MyLV_Item.pszText  = LPNR[dwItem].lpRemoteName;
                    MyLV_Item.mask     = LVIF_TEXT;
                    MyLV_Item.iSubItem = 1;
                    ListView_SetItem(hLanViewListBox, &MyLV_Item);

                    MyLV_Item.pszText  = LPNR[dwItem].lpComment;
                    MyLV_Item.mask     = LVIF_TEXT;
                    MyLV_Item.iSubItem = 5;
                    ListView_SetItem(hLanViewListBox, &MyLV_Item);

					Right(LPNR[dwItem].lpRemoteName, sTemp,
						strlen(LPNR[dwItem].lpRemoteName), strlen(LPNR[dwItem].lpRemoteName) - 2);

                    if(GetNodeInformation(sTemp))
                    {
                        MyLV_Item.mask     = LVIF_IMAGE;
                        MyLV_Item.iSubItem = 0;
                        MyLV_Item.iImage   = 0;
                        ListView_SetItem(hLanViewListBox, &MyLV_Item);
                    }
                    else{
                        MyLV_Item.mask     = LVIF_IMAGE;
                        MyLV_Item.iSubItem = 0;
                        MyLV_Item.iImage   = 1;
                        ListView_SetItem(hLanViewListBox, &MyLV_Item);
                    }
                }
            }

			Sleep(1);

			dwItem++;
        }

		free(LPNR);
    }
	while(dwStatus == ERROR_MORE_DATA);

    WNetCloseEnum(hEnum);

    return TRUE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int GetLANInfo(void)
{
    DWORD Result = 0;

	LV_ITEM MyLV_Item;
	memset(&MyLV_Item, 0, sizeof(MyLV_Item));

    WORD WSARequiredVersion;
    WSADATA WSAData;
    WSADATA *WSAPointerData;

    // -------- WINSOCK STARTUP --------
    WSARequiredVersion = 0x0101; // Version 1.1
    WSAPointerData = &WSAData;
    if((Result = WSAStartup(WSARequiredVersion, WSAPointerData)) != 0)
    {
        //ErrorMessage("Error in GetLANInfo: WSAStartup error.");
        return 0;
    }

    GetNetworkResources();

    if((Result = WSACleanup()) == SOCKET_ERROR)
    {
        //ErrorMessage("Error in GetLANInfo: WSACleanup error.");
        return 0;
    }

    return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI POPGrid_Thread(LPVOID xData)
{
    GetLANInfo();

    Set_Text(hStatusText, "Complete.");

    Sleep(2000);

    EndDialog(hScanDialog, 1234);

    return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
